/*!
    \file
    \copyright  (c) 2015 Jascha Wetzel. All rights reserved.
 */

#ifndef INTERFACE_IDS_H
#define INTERFACE_IDS_H

namespace tfd {
namespace api {

namespace InterfaceIds {
enum {
    invalid = 0,
    channel,
    channel_container,
    channel_container_factory,
    shader,
    shader_factory,
    api_version
};
}

struct Channel;
struct ChannelContainer;
struct ChannelContainerFactory;
struct Shader;
struct ShaderFactory;
struct ServerVersion;

template<class>
struct InterfaceId;

template<>
struct InterfaceId<Channel> {
    static const unsigned int id = InterfaceIds::channel;
};

template<>
struct InterfaceId<ChannelContainer> {
    static const unsigned int id = InterfaceIds::channel_container;
};

template<>
struct InterfaceId<ChannelContainerFactory> {
    static const unsigned int id = InterfaceIds::channel_container_factory;
};

template<>
struct InterfaceId<Shader> {
    static const unsigned int id = InterfaceIds::shader;
};

template<>
struct InterfaceId<ShaderFactory> {
    static const unsigned int id = InterfaceIds::shader_factory;
};

template<>
struct InterfaceId<ServerVersion> {
    static const unsigned int id = InterfaceIds::api_version;
};

} // namespace api
} // namespace tfd

#endif // INTERFACE_IDS_H
